package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  DomainName,
  Arn,
  Description,
  Version,
  DurationInSecondsOptional,
  Name
}
import scala.jdk.CollectionConverters.*
final case class RegisterWorkflowTypeRequest(
    domain: DomainName,
    name: Name,
    version: Version,
    description: Optional[Description] = Optional.Absent,
    defaultTaskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    defaultExecutionStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    defaultTaskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    defaultTaskPriority: Optional[TaskPriority] = Optional.Absent,
    defaultChildPolicy: Optional[zio.aws.swf.model.ChildPolicy] =
      Optional.Absent,
    defaultLambdaRole: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest = {
    import RegisterWorkflowTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        defaultTaskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultTaskStartToCloseTimeout)
      .optionallyWith(
        defaultExecutionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.defaultExecutionStartToCloseTimeout)
      .optionallyWith(defaultTaskList.map(value => value.buildAwsValue()))(
        _.defaultTaskList
      )
      .optionallyWith(
        defaultTaskPriority.map(value =>
          TaskPriority.unwrap(value): java.lang.String
        )
      )(_.defaultTaskPriority)
      .optionallyWith(defaultChildPolicy.map(value => value.unwrap))(
        _.defaultChildPolicy
      )
      .optionallyWith(
        defaultLambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.defaultLambdaRole)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.RegisterWorkflowTypeRequest.ReadOnly =
    zio.aws.swf.model.RegisterWorkflowTypeRequest.wrap(buildAwsValue())
}
object RegisterWorkflowTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RegisterWorkflowTypeRequest =
      zio.aws.swf.model.RegisterWorkflowTypeRequest(
        domain,
        name,
        version,
        description.map(value => value),
        defaultTaskStartToCloseTimeout.map(value => value),
        defaultExecutionStartToCloseTimeout.map(value => value),
        defaultTaskList.map(value => value.asEditable),
        defaultTaskPriority.map(value => value),
        defaultChildPolicy.map(value => value),
        defaultLambdaRole.map(value => value)
      )
    def domain: DomainName
    def name: Name
    def version: Version
    def description: Optional[Description]
    def defaultTaskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def defaultExecutionStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def defaultTaskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def defaultTaskPriority: Optional[TaskPriority]
    def defaultChildPolicy: Optional[zio.aws.swf.model.ChildPolicy]
    def defaultLambdaRole: Optional[Arn]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultTaskStartToCloseTimeout",
        defaultTaskStartToCloseTimeout
      )
    def getDefaultExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "defaultExecutionStartToCloseTimeout",
        defaultExecutionStartToCloseTimeout
      )
    def getDefaultTaskList
        : ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("defaultTaskList", defaultTaskList)
    def getDefaultTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("defaultTaskPriority", defaultTaskPriority)
    def getDefaultChildPolicy
        : ZIO[Any, AwsError, zio.aws.swf.model.ChildPolicy] =
      AwsError.unwrapOptionField("defaultChildPolicy", defaultChildPolicy)
    def getDefaultLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("defaultLambdaRole", defaultLambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest
  ) extends zio.aws.swf.model.RegisterWorkflowTypeRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val name: Name = zio.aws.swf.model.primitives.Name(impl.name())
    override val version: Version =
      zio.aws.swf.model.primitives.Version(impl.version())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.swf.model.primitives.Description(value))
    override val defaultTaskStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultExecutionStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultExecutionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val defaultTaskList
        : Optional[zio.aws.swf.model.TaskList.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTaskList())
      .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val defaultTaskPriority: Optional[TaskPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTaskPriority())
        .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val defaultChildPolicy: Optional[zio.aws.swf.model.ChildPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultChildPolicy())
        .map(value => zio.aws.swf.model.ChildPolicy.wrap(value))
    override val defaultLambdaRole: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultLambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest
  ): zio.aws.swf.model.RegisterWorkflowTypeRequest.ReadOnly = new Wrapper(impl)
}
