package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters.*
final case class FailWorkflowExecutionFailedEventAttributes(
    cause: zio.aws.swf.model.FailWorkflowExecutionFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.FailWorkflowExecutionFailedEventAttributes = {
    import FailWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.FailWorkflowExecutionFailedEventAttributes
      .builder()
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object FailWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.FailWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes(
        cause,
        decisionTaskCompletedEventId
      )
    def cause: zio.aws.swf.model.FailWorkflowExecutionFailedCause
    def decisionTaskCompletedEventId: EventId
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.FailWorkflowExecutionFailedCause
    ] = ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.FailWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val cause: zio.aws.swf.model.FailWorkflowExecutionFailedCause =
      zio.aws.swf.model.FailWorkflowExecutionFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.FailWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
