package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class DescribeWorkflowTypeRequest(
    domain: DomainName,
    workflowType: zio.aws.swf.model.WorkflowType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest = {
    import DescribeWorkflowTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .workflowType(workflowType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeWorkflowTypeRequest.ReadOnly =
    zio.aws.swf.model.DescribeWorkflowTypeRequest.wrap(buildAwsValue())
}
object DescribeWorkflowTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeWorkflowTypeRequest =
      zio.aws.swf.model
        .DescribeWorkflowTypeRequest(domain, workflowType.asEditable)
    def domain: DomainName
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest
  ) extends zio.aws.swf.model.DescribeWorkflowTypeRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest
  ): zio.aws.swf.model.DescribeWorkflowTypeRequest.ReadOnly = new Wrapper(impl)
}
