package zio.aws.swf.model
import scala.jdk.CollectionConverters.*
sealed trait RecordMarkerFailedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause
}
object RecordMarkerFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause
  ): zio.aws.swf.model.RecordMarkerFailedCause = value match {
    case software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause.OPERATION_NOT_PERMITTED =>
      val r = OPERATION_NOT_PERMITTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.RecordMarkerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause =
      software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object OPERATION_NOT_PERMITTED
      extends zio.aws.swf.model.RecordMarkerFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause =
      software.amazon.awssdk.services.swf.model.RecordMarkerFailedCause.OPERATION_NOT_PERMITTED
  }
}
