package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{EventId, Data}
import scala.jdk.CollectionConverters.*
final case class DecisionTaskCompletedEventAttributes(
    executionContext: Option[Data] = None,
    scheduledEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes = {
    import DecisionTaskCompletedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
      .builder()
      .optionallyWith(
        executionContext.map(value => Data.unwrap(value): java.lang.String)
      )(_.executionContext)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly =
    zio.aws.swf.model.DecisionTaskCompletedEventAttributes.wrap(buildAwsValue())
}
object DecisionTaskCompletedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DecisionTaskCompletedEventAttributes =
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes(
        executionContext.map(value => value),
        scheduledEventId,
        startedEventId
      )
    def executionContext: Option[Data]
    def scheduledEventId: EventId
    def startedEventId: EventId
    def getExecutionContext: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("executionContext", executionContext)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
  ) extends zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly {
    override val executionContext: Option[Data] = scala
      .Option(impl.executionContext())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
  ): zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
