package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Data, TaskToken}
import scala.jdk.CollectionConverters.*
final case class RespondDecisionTaskCompletedRequest(
    taskToken: TaskToken,
    decisions: Option[Iterable[zio.aws.swf.model.Decision]] = None,
    executionContext: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest = {
    import RespondDecisionTaskCompletedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        decisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.decisions)
      .optionallyWith(
        executionContext.map(value => Data.unwrap(value): java.lang.String)
      )(_.executionContext)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RespondDecisionTaskCompletedRequest.ReadOnly =
    zio.aws.swf.model.RespondDecisionTaskCompletedRequest.wrap(buildAwsValue())
}
object RespondDecisionTaskCompletedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RespondDecisionTaskCompletedRequest =
      zio.aws.swf.model.RespondDecisionTaskCompletedRequest(
        taskToken,
        decisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionContext.map(value => value)
      )
    def taskToken: TaskToken
    def decisions: Option[List[zio.aws.swf.model.Decision.ReadOnly]]
    def executionContext: Option[Data]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getDecisions
        : ZIO[Any, AwsError, List[zio.aws.swf.model.Decision.ReadOnly]] =
      AwsError.unwrapOptionField("decisions", decisions)
    def getExecutionContext: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("executionContext", executionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
  ) extends zio.aws.swf.model.RespondDecisionTaskCompletedRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val decisions: Option[List[zio.aws.swf.model.Decision.ReadOnly]] =
      scala
        .Option(impl.decisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.swf.model.Decision.wrap(item)
          }.toList
        )
    override val executionContext: Option[Data] = scala
      .Option(impl.executionContext())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
  ): zio.aws.swf.model.RespondDecisionTaskCompletedRequest.ReadOnly =
    new Wrapper(impl)
}
