package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{DurationInDays, Description, DomainName}
import scala.jdk.CollectionConverters.*
final case class RegisterDomainRequest(
    name: DomainName,
    description: Option[Description] = None,
    workflowExecutionRetentionPeriodInDays: DurationInDays,
    tags: Option[Iterable[zio.aws.swf.model.ResourceTag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RegisterDomainRequest = {
    import RegisterDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RegisterDomainRequest
      .builder()
      .name(DomainName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .workflowExecutionRetentionPeriodInDays(
        DurationInDays.unwrap(
          workflowExecutionRetentionPeriodInDays
        ): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.RegisterDomainRequest.ReadOnly =
    zio.aws.swf.model.RegisterDomainRequest.wrap(buildAwsValue())
}
object RegisterDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RegisterDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RegisterDomainRequest =
      zio.aws.swf.model.RegisterDomainRequest(
        name,
        description.map(value => value),
        workflowExecutionRetentionPeriodInDays,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: DomainName
    def description: Option[Description]
    def workflowExecutionRetentionPeriodInDays: DurationInDays
    def tags: Option[List[zio.aws.swf.model.ResourceTag.ReadOnly]]
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getWorkflowExecutionRetentionPeriodInDays
        : ZIO[Any, Nothing, DurationInDays] =
      ZIO.succeed(workflowExecutionRetentionPeriodInDays)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.swf.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RegisterDomainRequest
  ) extends zio.aws.swf.model.RegisterDomainRequest.ReadOnly {
    override val name: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.swf.model.primitives.Description(value))
    override val workflowExecutionRetentionPeriodInDays: DurationInDays =
      zio.aws.swf.model.primitives
        .DurationInDays(impl.workflowExecutionRetentionPeriodInDays())
    override val tags: Option[List[zio.aws.swf.model.ResourceTag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.swf.model.ResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RegisterDomainRequest
  ): zio.aws.swf.model.RegisterDomainRequest.ReadOnly = new Wrapper(impl)
}
