package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{CauseMessage, EventId}
import scala.jdk.CollectionConverters.*
final case class StartLambdaFunctionFailedEventAttributes(
    scheduledEventId: Option[EventId] = None,
    cause: Option[zio.aws.swf.model.StartLambdaFunctionFailedCause] = None,
    message: Option[CauseMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes = {
    import StartLambdaFunctionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes
      .builder()
      .optionallyWith(
        scheduledEventId.map(value => EventId.unwrap(value): java.lang.Long)
      )(_.scheduledEventId)
      .optionallyWith(cause.map(value => value.unwrap))(_.cause)
      .optionallyWith(
        message.map(value => CauseMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes
      .wrap(buildAwsValue())
}
object StartLambdaFunctionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes =
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes(
        scheduledEventId.map(value => value),
        cause.map(value => value),
        message.map(value => value)
      )
    def scheduledEventId: Option[EventId]
    def cause: Option[zio.aws.swf.model.StartLambdaFunctionFailedCause]
    def message: Option[CauseMessage]
    def getScheduledEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("scheduledEventId", scheduledEventId)
    def getCause
        : ZIO[Any, AwsError, zio.aws.swf.model.StartLambdaFunctionFailedCause] =
      AwsError.unwrapOptionField("cause", cause)
    def getMessage: ZIO[Any, AwsError, CauseMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes
  ) extends zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly {
    override val scheduledEventId: Option[EventId] = scala
      .Option(impl.scheduledEventId())
      .map(value => zio.aws.swf.model.primitives.EventId(value))
    override val cause
        : Option[zio.aws.swf.model.StartLambdaFunctionFailedCause] = scala
      .Option(impl.cause())
      .map(value =>
        zio.aws.swf.model.StartLambdaFunctionFailedCause.wrap(value)
      )
    override val message: Option[CauseMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.swf.model.primitives.CauseMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes
  ): zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
