package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{EventId, Data, FailureReason}
import scala.jdk.CollectionConverters.*
final case class ActivityTaskFailedEventAttributes(
    reason: Option[FailureReason] = None,
    details: Option[Data] = None,
    scheduledEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes = {
    import ActivityTaskFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes
      .builder()
      .optionallyWith(
        reason.map(value => FailureReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskFailedEventAttributes.wrap(buildAwsValue())
}
object ActivityTaskFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTaskFailedEventAttributes =
      zio.aws.swf.model.ActivityTaskFailedEventAttributes(
        reason.map(value => value),
        details.map(value => value),
        scheduledEventId,
        startedEventId
      )
    def reason: Option[FailureReason]
    def details: Option[Data]
    def scheduledEventId: EventId
    def startedEventId: EventId
    def getReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly {
    override val reason: Option[FailureReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.swf.model.primitives.FailureReason(value))
    override val details: Option[Data] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes
  ): zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly = new Wrapper(
    impl
  )
}
