package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{ActivityId, EventId}
import scala.jdk.CollectionConverters.*
final case class ActivityTaskCancelRequestedEventAttributes(
    decisionTaskCompletedEventId: EventId,
    activityId: ActivityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskCancelRequestedEventAttributes = {
    import ActivityTaskCancelRequestedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskCancelRequestedEventAttributes
      .builder()
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes
      .wrap(buildAwsValue())
}
object ActivityTaskCancelRequestedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskCancelRequestedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes =
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes(
        decisionTaskCompletedEventId,
        activityId
      )
    def decisionTaskCompletedEventId: EventId
    def activityId: ActivityId
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskCancelRequestedEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly {
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskCancelRequestedEventAttributes
  ): zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
