package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Identity, DomainName}
import scala.jdk.CollectionConverters.*
final case class PollForActivityTaskRequest(
    domain: DomainName,
    taskList: zio.aws.swf.model.TaskList,
    identity: Option[Identity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest = {
    import PollForActivityTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        identity.map(value => Identity.unwrap(value): java.lang.String)
      )(_.identity)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.PollForActivityTaskRequest.ReadOnly =
    zio.aws.swf.model.PollForActivityTaskRequest.wrap(buildAwsValue())
}
object PollForActivityTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.PollForActivityTaskRequest =
      zio.aws.swf.model.PollForActivityTaskRequest(
        domain,
        taskList.asEditable,
        identity.map(value => value)
      )
    def domain: DomainName
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def identity: Option[Identity]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getIdentity: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("identity", identity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest
  ) extends zio.aws.swf.model.PollForActivityTaskRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val identity: Option[Identity] = scala
      .Option(impl.identity())
      .map(value => zio.aws.swf.model.primitives.Identity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest
  ): zio.aws.swf.model.PollForActivityTaskRequest.ReadOnly = new Wrapper(impl)
}
