package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.WorkflowRunId
import scala.jdk.CollectionConverters.*
final case class StartWorkflowExecutionResponse(
    runId: Option[WorkflowRunId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse = {
    import StartWorkflowExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse
      .builder()
      .optionallyWith(
        runId.map(value => WorkflowRunId.unwrap(value): java.lang.String)
      )(_.runId)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly =
    zio.aws.swf.model.StartWorkflowExecutionResponse.wrap(buildAwsValue())
}
object StartWorkflowExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.StartWorkflowExecutionResponse =
      zio.aws.swf.model
        .StartWorkflowExecutionResponse(runId.map(value => value))
    def runId: Option[WorkflowRunId]
    def getRunId: ZIO[Any, AwsError, WorkflowRunId] =
      AwsError.unwrapOptionField("runId", runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse
  ) extends zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly {
    override val runId: Option[WorkflowRunId] = scala
      .Option(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse
  ): zio.aws.swf.model.StartWorkflowExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
