package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class DescribeWorkflowExecutionRequest(
    domain: DomainName,
    execution: zio.aws.swf.model.WorkflowExecution
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest = {
    import DescribeWorkflowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .execution(execution.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeWorkflowExecutionRequest.ReadOnly =
    zio.aws.swf.model.DescribeWorkflowExecutionRequest.wrap(buildAwsValue())
}
object DescribeWorkflowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeWorkflowExecutionRequest =
      zio.aws.swf.model
        .DescribeWorkflowExecutionRequest(domain, execution.asEditable)
    def domain: DomainName
    def execution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(execution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest
  ) extends zio.aws.swf.model.DescribeWorkflowExecutionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val execution: zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.execution())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest
  ): zio.aws.swf.model.DescribeWorkflowExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
