package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, ActivityId}
import scala.jdk.CollectionConverters.*
final case class RequestCancelActivityTaskFailedEventAttributes(
    activityId: ActivityId,
    cause: zio.aws.swf.model.RequestCancelActivityTaskFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskFailedEventAttributes = {
    import RequestCancelActivityTaskFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskFailedEventAttributes
      .builder()
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes
      .wrap(buildAwsValue())
}
object RequestCancelActivityTaskFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes =
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes(
        activityId,
        cause,
        decisionTaskCompletedEventId
      )
    def activityId: ActivityId
    def cause: zio.aws.swf.model.RequestCancelActivityTaskFailedCause
    def decisionTaskCompletedEventId: EventId
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.RequestCancelActivityTaskFailedCause
    ] = ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskFailedEventAttributes
  ) extends zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly {
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val cause: zio.aws.swf.model.RequestCancelActivityTaskFailedCause =
      zio.aws.swf.model.RequestCancelActivityTaskFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskFailedEventAttributes
  ): zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
