package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Arn, Description, DomainName}
import scala.jdk.CollectionConverters.*
final case class DomainInfo(
    name: DomainName,
    status: zio.aws.swf.model.RegistrationStatus,
    description: Option[Description] = None,
    arn: Option[Arn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.swf.model.DomainInfo = {
    import DomainInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DomainInfo
      .builder()
      .name(DomainName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DomainInfo.ReadOnly =
    zio.aws.swf.model.DomainInfo.wrap(buildAwsValue())
}
object DomainInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.DomainInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DomainInfo = zio.aws.swf.model.DomainInfo(
      name,
      status,
      description.map(value => value),
      arn.map(value => value)
    )
    def name: DomainName
    def status: zio.aws.swf.model.RegistrationStatus
    def description: Option[Description]
    def arn: Option[Arn]
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DomainInfo
  ) extends zio.aws.swf.model.DomainInfo.ReadOnly {
    override val name: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.name())
    override val status: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.status())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.swf.model.primitives.Description(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DomainInfo
  ): zio.aws.swf.model.DomainInfo.ReadOnly = new Wrapper(impl)
}
