package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class CountOpenWorkflowExecutionsRequest(
    domain: DomainName,
    startTimeFilter: zio.aws.swf.model.ExecutionTimeFilter,
    typeFilter: Option[zio.aws.swf.model.WorkflowTypeFilter] = None,
    tagFilter: Option[zio.aws.swf.model.TagFilter] = None,
    executionFilter: Option[zio.aws.swf.model.WorkflowExecutionFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest = {
    import CountOpenWorkflowExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .startTimeFilter(startTimeFilter.buildAwsValue())
      .optionallyWith(typeFilter.map(value => value.buildAwsValue()))(
        _.typeFilter
      )
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .optionallyWith(executionFilter.map(value => value.buildAwsValue()))(
        _.executionFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CountOpenWorkflowExecutionsRequest.ReadOnly =
    zio.aws.swf.model.CountOpenWorkflowExecutionsRequest.wrap(buildAwsValue())
}
object CountOpenWorkflowExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CountOpenWorkflowExecutionsRequest =
      zio.aws.swf.model.CountOpenWorkflowExecutionsRequest(
        domain,
        startTimeFilter.asEditable,
        typeFilter.map(value => value.asEditable),
        tagFilter.map(value => value.asEditable),
        executionFilter.map(value => value.asEditable)
      )
    def domain: DomainName
    def startTimeFilter: zio.aws.swf.model.ExecutionTimeFilter.ReadOnly
    def typeFilter: Option[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly]
    def tagFilter: Option[zio.aws.swf.model.TagFilter.ReadOnly]
    def executionFilter
        : Option[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getStartTimeFilter
        : ZIO[Any, Nothing, zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      ZIO.succeed(startTimeFilter)
    def getTypeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      AwsError.unwrapOptionField("typeFilter", typeFilter)
    def getTagFilter: ZIO[Any, AwsError, zio.aws.swf.model.TagFilter.ReadOnly] =
      AwsError.unwrapOptionField("tagFilter", tagFilter)
    def getExecutionFilter: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("executionFilter", executionFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest
  ) extends zio.aws.swf.model.CountOpenWorkflowExecutionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val startTimeFilter
        : zio.aws.swf.model.ExecutionTimeFilter.ReadOnly =
      zio.aws.swf.model.ExecutionTimeFilter.wrap(impl.startTimeFilter())
    override val typeFilter
        : Option[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] = scala
      .Option(impl.typeFilter())
      .map(value => zio.aws.swf.model.WorkflowTypeFilter.wrap(value))
    override val tagFilter: Option[zio.aws.swf.model.TagFilter.ReadOnly] = scala
      .Option(impl.tagFilter())
      .map(value => zio.aws.swf.model.TagFilter.wrap(value))
    override val executionFilter
        : Option[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly] = scala
      .Option(impl.executionFilter())
      .map(value => zio.aws.swf.model.WorkflowExecutionFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest
  ): zio.aws.swf.model.CountOpenWorkflowExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
