package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  FunctionId,
  Data,
  FunctionInput,
  FunctionName,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters.*
final case class ScheduleLambdaFunctionDecisionAttributes(
    id: FunctionId,
    name: FunctionName,
    control: Option[Data] = None,
    input: Option[FunctionInput] = None,
    startToCloseTimeout: Option[DurationInSecondsOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes = {
    import ScheduleLambdaFunctionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes
      .builder()
      .id(FunctionId.unwrap(id): java.lang.String)
      .name(FunctionName.unwrap(name): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(
        input.map(value => FunctionInput.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes
      .wrap(buildAwsValue())
}
object ScheduleLambdaFunctionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes =
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes(
        id,
        name,
        control.map(value => value),
        input.map(value => value),
        startToCloseTimeout.map(value => value)
      )
    def id: FunctionId
    def name: FunctionName
    def control: Option[Data]
    def input: Option[FunctionInput]
    def startToCloseTimeout: Option[DurationInSecondsOptional]
    def getId: ZIO[Any, Nothing, FunctionId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, FunctionInput] =
      AwsError.unwrapOptionField("input", input)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes
  ) extends zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly {
    override val id: FunctionId =
      zio.aws.swf.model.primitives.FunctionId(impl.id())
    override val name: FunctionName =
      zio.aws.swf.model.primitives.FunctionName(impl.name())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Option[FunctionInput] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.FunctionInput(value))
    override val startToCloseTimeout: Option[DurationInSecondsOptional] = scala
      .Option(impl.startToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes
  ): zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
