package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.swf.model.primitives.{Data, Timestamp}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkflowExecutionResponse(
    executionInfo: zio.aws.swf.model.WorkflowExecutionInfo,
    executionConfiguration: zio.aws.swf.model.WorkflowExecutionConfiguration,
    openCounts: zio.aws.swf.model.WorkflowExecutionOpenCounts,
    latestActivityTaskTimestamp: Option[Timestamp] = None,
    latestExecutionContext: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse = {
    import DescribeWorkflowExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse
      .builder()
      .executionInfo(executionInfo.buildAwsValue())
      .executionConfiguration(executionConfiguration.buildAwsValue())
      .openCounts(openCounts.buildAwsValue())
      .optionallyWith(
        latestActivityTaskTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.latestActivityTaskTimestamp)
      .optionallyWith(
        latestExecutionContext.map(value =>
          Data.unwrap(value): java.lang.String
        )
      )(_.latestExecutionContext)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly =
    zio.aws.swf.model.DescribeWorkflowExecutionResponse.wrap(buildAwsValue())
}
object DescribeWorkflowExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeWorkflowExecutionResponse =
      zio.aws.swf.model.DescribeWorkflowExecutionResponse(
        executionInfo.asEditable,
        executionConfiguration.asEditable,
        openCounts.asEditable,
        latestActivityTaskTimestamp.map(value => value),
        latestExecutionContext.map(value => value)
      )
    def executionInfo: zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly
    def executionConfiguration
        : zio.aws.swf.model.WorkflowExecutionConfiguration.ReadOnly
    def openCounts: zio.aws.swf.model.WorkflowExecutionOpenCounts.ReadOnly
    def latestActivityTaskTimestamp: Option[Timestamp]
    def latestExecutionContext: Option[Data]
    def getExecutionInfo
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly] =
      ZIO.succeed(executionInfo)
    def getExecutionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.WorkflowExecutionConfiguration.ReadOnly
    ] = ZIO.succeed(executionConfiguration)
    def getOpenCounts: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.WorkflowExecutionOpenCounts.ReadOnly
    ] = ZIO.succeed(openCounts)
    def getLatestActivityTaskTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "latestActivityTaskTimestamp",
        latestActivityTaskTimestamp
      )
    def getLatestExecutionContext: ZIO[Any, AwsError, Data] = AwsError
      .unwrapOptionField("latestExecutionContext", latestExecutionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse
  ) extends zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly {
    override val executionInfo
        : zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly =
      zio.aws.swf.model.WorkflowExecutionInfo.wrap(impl.executionInfo())
    override val executionConfiguration
        : zio.aws.swf.model.WorkflowExecutionConfiguration.ReadOnly =
      zio.aws.swf.model.WorkflowExecutionConfiguration
        .wrap(impl.executionConfiguration())
    override val openCounts
        : zio.aws.swf.model.WorkflowExecutionOpenCounts.ReadOnly =
      zio.aws.swf.model.WorkflowExecutionOpenCounts.wrap(impl.openCounts())
    override val latestActivityTaskTimestamp: Option[Timestamp] = scala
      .Option(impl.latestActivityTaskTimestamp())
      .map(value => zio.aws.swf.model.primitives.Timestamp(value))
    override val latestExecutionContext: Option[Data] = scala
      .Option(impl.latestExecutionContext())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse
  ): zio.aws.swf.model.DescribeWorkflowExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
