package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.Data
import scala.jdk.CollectionConverters.*
final case class CancelWorkflowExecutionDecisionAttributes(
    details: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionDecisionAttributes = {
    import CancelWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionDecisionAttributes
      .builder()
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object CancelWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model
        .CancelWorkflowExecutionDecisionAttributes(details.map(value => value))
    def details: Option[Data]
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly {
    override val details: Option[Data] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
