package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  Tag,
  DomainName,
  Arn,
  DurationInSecondsOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters.*
final case class StartWorkflowExecutionRequest(
    domain: DomainName,
    workflowId: WorkflowId,
    workflowType: zio.aws.swf.model.WorkflowType,
    taskList: Option[zio.aws.swf.model.TaskList] = None,
    taskPriority: Option[TaskPriority] = None,
    input: Option[Data] = None,
    executionStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    tagList: Option[Iterable[Tag]] = None,
    taskStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    childPolicy: Option[zio.aws.swf.model.ChildPolicy] = None,
    lambdaRole: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest = {
    import StartWorkflowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .optionallyWith(childPolicy.map(value => value.unwrap))(_.childPolicy)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.StartWorkflowExecutionRequest.ReadOnly =
    zio.aws.swf.model.StartWorkflowExecutionRequest.wrap(buildAwsValue())
}
object StartWorkflowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.StartWorkflowExecutionRequest =
      zio.aws.swf.model.StartWorkflowExecutionRequest(
        domain,
        workflowId,
        workflowType.asEditable,
        taskList.map(value => value.asEditable),
        taskPriority.map(value => value),
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        tagList.map(value => value),
        taskStartToCloseTimeout.map(value => value),
        childPolicy.map(value => value),
        lambdaRole.map(value => value)
      )
    def domain: DomainName
    def workflowId: WorkflowId
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def taskList: Option[zio.aws.swf.model.TaskList.ReadOnly]
    def taskPriority: Option[TaskPriority]
    def input: Option[Data]
    def executionStartToCloseTimeout: Option[DurationInSecondsOptional]
    def tagList: Option[List[Tag]]
    def taskStartToCloseTimeout: Option[DurationInSecondsOptional]
    def childPolicy: Option[zio.aws.swf.model.ChildPolicy]
    def lambdaRole: Option[Arn]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getChildPolicy: ZIO[Any, AwsError, zio.aws.swf.model.ChildPolicy] =
      AwsError.unwrapOptionField("childPolicy", childPolicy)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest
  ) extends zio.aws.swf.model.StartWorkflowExecutionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val taskList: Option[zio.aws.swf.model.TaskList.ReadOnly] = scala
      .Option(impl.taskList())
      .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskPriority: Option[TaskPriority] = scala
      .Option(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Option[DurationInSecondsOptional] = scala
      .Option(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val tagList: Option[List[Tag]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val taskStartToCloseTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val childPolicy: Option[zio.aws.swf.model.ChildPolicy] = scala
      .Option(impl.childPolicy())
      .map(value => zio.aws.swf.model.ChildPolicy.wrap(value))
    override val lambdaRole: Option[Arn] = scala
      .Option(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest
  ): zio.aws.swf.model.StartWorkflowExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
