package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  TaskPriority,
  DurationInSecondsOptional,
  Data,
  ActivityId
}
import scala.jdk.CollectionConverters.*
final case class ScheduleActivityTaskDecisionAttributes(
    activityType: zio.aws.swf.model.ActivityType,
    activityId: ActivityId,
    control: Option[Data] = None,
    input: Option[Data] = None,
    scheduleToCloseTimeout: Option[DurationInSecondsOptional] = None,
    taskList: Option[zio.aws.swf.model.TaskList] = None,
    taskPriority: Option[TaskPriority] = None,
    scheduleToStartTimeout: Option[DurationInSecondsOptional] = None,
    startToCloseTimeout: Option[DurationInSecondsOptional] = None,
    heartbeatTimeout: Option[DurationInSecondsOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes = {
    import ScheduleActivityTaskDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
      .builder()
      .activityType(activityType.buildAwsValue())
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        scheduleToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToCloseTimeout)
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(
        scheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToStartTimeout)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .optionallyWith(
        heartbeatTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.heartbeatTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly =
    zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes
      .wrap(buildAwsValue())
}
object ScheduleActivityTaskDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes =
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes(
        activityType.asEditable,
        activityId,
        control.map(value => value),
        input.map(value => value),
        scheduleToCloseTimeout.map(value => value),
        taskList.map(value => value.asEditable),
        taskPriority.map(value => value),
        scheduleToStartTimeout.map(value => value),
        startToCloseTimeout.map(value => value),
        heartbeatTimeout.map(value => value)
      )
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def activityId: ActivityId
    def control: Option[Data]
    def input: Option[Data]
    def scheduleToCloseTimeout: Option[DurationInSecondsOptional]
    def taskList: Option[zio.aws.swf.model.TaskList.ReadOnly]
    def taskPriority: Option[TaskPriority]
    def scheduleToStartTimeout: Option[DurationInSecondsOptional]
    def startToCloseTimeout: Option[DurationInSecondsOptional]
    def heartbeatTimeout: Option[DurationInSecondsOptional]
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getScheduleToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToCloseTimeout", scheduleToCloseTimeout)
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToStartTimeout", scheduleToStartTimeout)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
    def getHeartbeatTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("heartbeatTimeout", heartbeatTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
  ) extends zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly {
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduleToCloseTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.scheduleToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val taskList: Option[zio.aws.swf.model.TaskList.ReadOnly] = scala
      .Option(impl.taskList())
      .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskPriority: Option[TaskPriority] = scala
      .Option(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val scheduleToStartTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.scheduleToStartTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val startToCloseTimeout: Option[DurationInSecondsOptional] = scala
      .Option(impl.startToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val heartbeatTimeout: Option[DurationInSecondsOptional] = scala
      .Option(impl.heartbeatTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
  ): zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
