package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionTimedOutEventAttributes(
    scheduledEventId: EventId,
    startedEventId: EventId,
    timeoutType: Option[zio.aws.swf.model.LambdaFunctionTimeoutType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes = {
    import LambdaFunctionTimedOutEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes
      .builder()
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .optionallyWith(timeoutType.map(value => value.unwrap))(_.timeoutType)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly =
    zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes
      .wrap(buildAwsValue())
}
object LambdaFunctionTimedOutEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes =
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes(
        scheduledEventId,
        startedEventId,
        timeoutType.map(value => value)
      )
    def scheduledEventId: EventId
    def startedEventId: EventId
    def timeoutType: Option[zio.aws.swf.model.LambdaFunctionTimeoutType]
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getTimeoutType
        : ZIO[Any, AwsError, zio.aws.swf.model.LambdaFunctionTimeoutType] =
      AwsError.unwrapOptionField("timeoutType", timeoutType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes
  ) extends zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly {
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val timeoutType
        : Option[zio.aws.swf.model.LambdaFunctionTimeoutType] = scala
      .Option(impl.timeoutType())
      .map(value => zio.aws.swf.model.LambdaFunctionTimeoutType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes
  ): zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly =
    new Wrapper(impl)
}
