package zio.aws.swf.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  Identity,
  ReverseOrder,
  DomainName,
  PageToken,
  PageSize
}
import scala.jdk.CollectionConverters.*
final case class PollForDecisionTaskRequest(
    domain: DomainName,
    taskList: zio.aws.swf.model.TaskList,
    identity: Option[Identity] = None,
    nextPageToken: Option[PageToken] = None,
    maximumPageSize: Option[PageSize] = None,
    reverseOrder: Option[ReverseOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest = {
    import PollForDecisionTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        identity.map(value => Identity.unwrap(value): java.lang.String)
      )(_.identity)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.PollForDecisionTaskRequest.ReadOnly =
    zio.aws.swf.model.PollForDecisionTaskRequest.wrap(buildAwsValue())
}
object PollForDecisionTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.PollForDecisionTaskRequest =
      zio.aws.swf.model.PollForDecisionTaskRequest(
        domain,
        taskList.asEditable,
        identity.map(value => value),
        nextPageToken.map(value => value),
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def domain: DomainName
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def identity: Option[Identity]
    def nextPageToken: Option[PageToken]
    def maximumPageSize: Option[PageSize]
    def reverseOrder: Option[ReverseOrder]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getIdentity: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("identity", identity)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest
  ) extends zio.aws.swf.model.PollForDecisionTaskRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val identity: Option[Identity] = scala
      .Option(impl.identity())
      .map(value => zio.aws.swf.model.primitives.Identity(value))
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val maximumPageSize: Option[PageSize] = scala
      .Option(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Option[ReverseOrder] = scala
      .Option(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest
  ): zio.aws.swf.model.PollForDecisionTaskRequest.ReadOnly = new Wrapper(impl)
}
