package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.swf.model.ResourceTag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.swf.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListTagsForResourceResponse =
      zio.aws.swf.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.swf.model.ResourceTag.ReadOnly]]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.swf.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse
  ) extends zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.swf.model.ResourceTag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.swf.model.ResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse
  ): zio.aws.swf.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(impl)
}
