package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  ActivityId,
  EventId,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters.*
final case class ActivityTaskScheduledEventAttributes(
    activityType: zio.aws.swf.model.ActivityType,
    activityId: ActivityId,
    input: Option[Data] = None,
    control: Option[Data] = None,
    scheduleToStartTimeout: Option[DurationInSecondsOptional] = None,
    scheduleToCloseTimeout: Option[DurationInSecondsOptional] = None,
    startToCloseTimeout: Option[DurationInSecondsOptional] = None,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Option[TaskPriority] = None,
    decisionTaskCompletedEventId: EventId,
    heartbeatTimeout: Option[DurationInSecondsOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes = {
    import ActivityTaskScheduledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
      .builder()
      .activityType(activityType.buildAwsValue())
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(
        scheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToStartTimeout)
      .optionallyWith(
        scheduleToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToCloseTimeout)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .optionallyWith(
        heartbeatTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.heartbeatTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskScheduledEventAttributes.wrap(buildAwsValue())
}
object ActivityTaskScheduledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTaskScheduledEventAttributes =
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes(
        activityType.asEditable,
        activityId,
        input.map(value => value),
        control.map(value => value),
        scheduleToStartTimeout.map(value => value),
        scheduleToCloseTimeout.map(value => value),
        startToCloseTimeout.map(value => value),
        taskList.asEditable,
        taskPriority.map(value => value),
        decisionTaskCompletedEventId,
        heartbeatTimeout.map(value => value)
      )
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def activityId: ActivityId
    def input: Option[Data]
    def control: Option[Data]
    def scheduleToStartTimeout: Option[DurationInSecondsOptional]
    def scheduleToCloseTimeout: Option[DurationInSecondsOptional]
    def startToCloseTimeout: Option[DurationInSecondsOptional]
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Option[TaskPriority]
    def decisionTaskCompletedEventId: EventId
    def heartbeatTimeout: Option[DurationInSecondsOptional]
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToStartTimeout", scheduleToStartTimeout)
    def getScheduleToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToCloseTimeout", scheduleToCloseTimeout)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getHeartbeatTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("heartbeatTimeout", heartbeatTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly {
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduleToStartTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.scheduleToStartTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val scheduleToCloseTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.scheduleToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val startToCloseTimeout: Option[DurationInSecondsOptional] = scala
      .Option(impl.startToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Option[TaskPriority] = scala
      .Option(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val heartbeatTimeout: Option[DurationInSecondsOptional] = scala
      .Option(impl.heartbeatTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes
  ): zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
