package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  WorkflowRunIdOptional,
  Tag,
  Arn,
  EventId,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters.*
final case class WorkflowExecutionStartedEventAttributes(
    input: Option[Data] = None,
    executionStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    taskStartToCloseTimeout: Option[DurationInSecondsOptional] = None,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Option[TaskPriority] = None,
    workflowType: zio.aws.swf.model.WorkflowType,
    tagList: Option[Iterable[Tag]] = None,
    continuedExecutionRunId: Option[WorkflowRunIdOptional] = None,
    parentWorkflowExecution: Option[zio.aws.swf.model.WorkflowExecution] = None,
    parentInitiatedEventId: Option[EventId] = None,
    lambdaRole: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes = {
    import WorkflowExecutionStartedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
      .builder()
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .childPolicy(childPolicy.unwrap)
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        continuedExecutionRunId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.continuedExecutionRunId)
      .optionallyWith(
        parentWorkflowExecution.map(value => value.buildAwsValue())
      )(_.parentWorkflowExecution)
      .optionallyWith(
        parentInitiatedEventId.map(value =>
          EventId.unwrap(value): java.lang.Long
        )
      )(_.parentInitiatedEventId)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionStartedEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionStartedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionStartedEventAttributes =
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes(
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        taskStartToCloseTimeout.map(value => value),
        childPolicy,
        taskList.asEditable,
        taskPriority.map(value => value),
        workflowType.asEditable,
        tagList.map(value => value),
        continuedExecutionRunId.map(value => value),
        parentWorkflowExecution.map(value => value.asEditable),
        parentInitiatedEventId.map(value => value),
        lambdaRole.map(value => value)
      )
    def input: Option[Data]
    def executionStartToCloseTimeout: Option[DurationInSecondsOptional]
    def taskStartToCloseTimeout: Option[DurationInSecondsOptional]
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Option[TaskPriority]
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def tagList: Option[List[Tag]]
    def continuedExecutionRunId: Option[WorkflowRunIdOptional]
    def parentWorkflowExecution
        : Option[zio.aws.swf.model.WorkflowExecution.ReadOnly]
    def parentInitiatedEventId: Option[EventId]
    def lambdaRole: Option[Arn]
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getContinuedExecutionRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField(
        "continuedExecutionRunId",
        continuedExecutionRunId
      )
    def getParentWorkflowExecution
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      AwsError.unwrapOptionField(
        "parentWorkflowExecution",
        parentWorkflowExecution
      )
    def getParentInitiatedEventId: ZIO[Any, AwsError, EventId] = AwsError
      .unwrapOptionField("parentInitiatedEventId", parentInitiatedEventId)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly {
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Option[DurationInSecondsOptional] = scala
      .Option(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskStartToCloseTimeout: Option[DurationInSecondsOptional] =
      scala
        .Option(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Option[TaskPriority] = scala
      .Option(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val tagList: Option[List[Tag]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val continuedExecutionRunId: Option[WorkflowRunIdOptional] = scala
      .Option(impl.continuedExecutionRunId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val parentWorkflowExecution
        : Option[zio.aws.swf.model.WorkflowExecution.ReadOnly] = scala
      .Option(impl.parentWorkflowExecution())
      .map(value => zio.aws.swf.model.WorkflowExecution.wrap(value))
    override val parentInitiatedEventId: Option[EventId] = scala
      .Option(impl.parentInitiatedEventId())
      .map(value => zio.aws.swf.model.primitives.EventId(value))
    override val lambdaRole: Option[Arn] = scala
      .Option(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
