package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{ResourceTagKey, Arn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: Arn,
    tagKeys: Iterable[ResourceTagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.UntagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        ResourceTagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.UntagResourceRequest.ReadOnly =
    zio.aws.swf.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.UntagResourceRequest =
      zio.aws.swf.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: Arn
    def tagKeys: List[ResourceTagKey]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[ResourceTagKey]] =
      ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.UntagResourceRequest
  ) extends zio.aws.swf.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.swf.model.primitives.Arn(impl.resourceArn())
    override val tagKeys: List[ResourceTagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.swf.model.primitives.ResourceTagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.UntagResourceRequest
  ): zio.aws.swf.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
