package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{EventId, DurationInSeconds, Data, TimerId}
import scala.jdk.CollectionConverters.*
final case class TimerStartedEventAttributes(
    timerId: TimerId,
    control: Option[Data] = None,
    startToFireTimeout: DurationInSeconds,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes = {
    import TimerStartedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .startToFireTimeout(
        DurationInSeconds.unwrap(startToFireTimeout): java.lang.String
      )
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly =
    zio.aws.swf.model.TimerStartedEventAttributes.wrap(buildAwsValue())
}
object TimerStartedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TimerStartedEventAttributes =
      zio.aws.swf.model.TimerStartedEventAttributes(
        timerId,
        control.map(value => value),
        startToFireTimeout,
        decisionTaskCompletedEventId
      )
    def timerId: TimerId
    def control: Option[Data]
    def startToFireTimeout: DurationInSeconds
    def decisionTaskCompletedEventId: EventId
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getStartToFireTimeout: ZIO[Any, Nothing, DurationInSeconds] =
      ZIO.succeed(startToFireTimeout)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes
  ) extends zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val startToFireTimeout: DurationInSeconds =
      zio.aws.swf.model.primitives.DurationInSeconds(impl.startToFireTimeout())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes
  ): zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly = new Wrapper(impl)
}
