package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, TimerId}
import scala.jdk.CollectionConverters.*
final case class StartTimerFailedEventAttributes(
    timerId: TimerId,
    cause: zio.aws.swf.model.StartTimerFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes = {
    import StartTimerFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.StartTimerFailedEventAttributes.wrap(buildAwsValue())
}
object StartTimerFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.StartTimerFailedEventAttributes =
      zio.aws.swf.model.StartTimerFailedEventAttributes(
        timerId,
        cause,
        decisionTaskCompletedEventId
      )
    def timerId: TimerId
    def cause: zio.aws.swf.model.StartTimerFailedCause
    def decisionTaskCompletedEventId: EventId
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
    def getCause: ZIO[Any, Nothing, zio.aws.swf.model.StartTimerFailedCause] =
      ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes
  ) extends zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
    override val cause: zio.aws.swf.model.StartTimerFailedCause =
      zio.aws.swf.model.StartTimerFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes
  ): zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly = new Wrapper(
    impl
  )
}
