package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  Data,
  WorkflowRunIdOptional,
  EventId,
  SignalName,
  WorkflowId
}
import scala.jdk.CollectionConverters.*
final case class SignalExternalWorkflowExecutionInitiatedEventAttributes(
    workflowId: WorkflowId,
    runId: Option[WorkflowRunIdOptional] = None,
    signalName: SignalName,
    input: Option[Data] = None,
    decisionTaskCompletedEventId: EventId,
    control: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes = {
    import SignalExternalWorkflowExecutionInitiatedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .signalName(SignalName.unwrap(signalName): java.lang.String)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
      .wrap(buildAwsValue())
}
object SignalExternalWorkflowExecutionInitiatedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes =
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes(
        workflowId,
        runId.map(value => value),
        signalName,
        input.map(value => value),
        decisionTaskCompletedEventId,
        control.map(value => value)
      )
    def workflowId: WorkflowId
    def runId: Option[WorkflowRunIdOptional]
    def signalName: SignalName
    def input: Option[Data]
    def decisionTaskCompletedEventId: EventId
    def control: Option[Data]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getSignalName: ZIO[Any, Nothing, SignalName] = ZIO.succeed(signalName)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
  ) extends zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Option[WorkflowRunIdOptional] = scala
      .Option(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val signalName: SignalName =
      zio.aws.swf.model.primitives.SignalName(impl.signalName())
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
  ): zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
