package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Data, FailureReason, TaskToken}
import scala.jdk.CollectionConverters.*
final case class RespondActivityTaskFailedRequest(
    taskToken: TaskToken,
    reason: Option[FailureReason] = None,
    details: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest = {
    import RespondActivityTaskFailedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        reason.map(value => FailureReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.RespondActivityTaskFailedRequest.ReadOnly =
    zio.aws.swf.model.RespondActivityTaskFailedRequest.wrap(buildAwsValue())
}
object RespondActivityTaskFailedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RespondActivityTaskFailedRequest =
      zio.aws.swf.model.RespondActivityTaskFailedRequest(
        taskToken,
        reason.map(value => value),
        details.map(value => value)
      )
    def taskToken: TaskToken
    def reason: Option[FailureReason]
    def details: Option[Data]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest
  ) extends zio.aws.swf.model.RespondActivityTaskFailedRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val reason: Option[FailureReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.swf.model.primitives.FailureReason(value))
    override val details: Option[Data] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest
  ): zio.aws.swf.model.RespondActivityTaskFailedRequest.ReadOnly = new Wrapper(
    impl
  )
}
