package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Data, TaskToken}
import scala.jdk.CollectionConverters.*
final case class RespondActivityTaskCanceledRequest(
    taskToken: TaskToken,
    details: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest = {
    import RespondActivityTaskCanceledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RespondActivityTaskCanceledRequest.ReadOnly =
    zio.aws.swf.model.RespondActivityTaskCanceledRequest.wrap(buildAwsValue())
}
object RespondActivityTaskCanceledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RespondActivityTaskCanceledRequest =
      zio.aws.swf.model.RespondActivityTaskCanceledRequest(
        taskToken,
        details.map(value => value)
      )
    def taskToken: TaskToken
    def details: Option[Data]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest
  ) extends zio.aws.swf.model.RespondActivityTaskCanceledRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val details: Option[Data] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest
  ): zio.aws.swf.model.RespondActivityTaskCanceledRequest.ReadOnly =
    new Wrapper(impl)
}
