package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.ActivityId
import scala.jdk.CollectionConverters.*
final case class RequestCancelActivityTaskDecisionAttributes(
    activityId: ActivityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskDecisionAttributes = {
    import RequestCancelActivityTaskDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskDecisionAttributes
      .builder()
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly =
    zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes
      .wrap(buildAwsValue())
}
object RequestCancelActivityTaskDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes =
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes(activityId)
    def activityId: ActivityId
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskDecisionAttributes
  ) extends zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly {
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskDecisionAttributes
  ): zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
