package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.swf.model.primitives.{Canceled, Tag, Timestamp}
import scala.jdk.CollectionConverters.*
final case class WorkflowExecutionInfo(
    execution: zio.aws.swf.model.WorkflowExecution,
    workflowType: zio.aws.swf.model.WorkflowType,
    startTimestamp: Timestamp,
    closeTimestamp: Option[Timestamp] = None,
    executionStatus: zio.aws.swf.model.ExecutionStatus,
    closeStatus: Option[zio.aws.swf.model.CloseStatus] = None,
    parent: Option[zio.aws.swf.model.WorkflowExecution] = None,
    tagList: Option[Iterable[Tag]] = None,
    cancelRequested: Option[Canceled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo = {
    import WorkflowExecutionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo
      .builder()
      .execution(execution.buildAwsValue())
      .workflowType(workflowType.buildAwsValue())
      .startTimestamp(Timestamp.unwrap(startTimestamp): Instant)
      .optionallyWith(
        closeTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.closeTimestamp)
      .executionStatus(executionStatus.unwrap)
      .optionallyWith(closeStatus.map(value => value.unwrap))(_.closeStatus)
      .optionallyWith(parent.map(value => value.buildAwsValue()))(_.parent)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        cancelRequested.map(value => Canceled.unwrap(value): java.lang.Boolean)
      )(_.cancelRequested)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionInfo.wrap(buildAwsValue())
}
object WorkflowExecutionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionInfo =
      zio.aws.swf.model.WorkflowExecutionInfo(
        execution.asEditable,
        workflowType.asEditable,
        startTimestamp,
        closeTimestamp.map(value => value),
        executionStatus,
        closeStatus.map(value => value),
        parent.map(value => value.asEditable),
        tagList.map(value => value),
        cancelRequested.map(value => value)
      )
    def execution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def startTimestamp: Timestamp
    def closeTimestamp: Option[Timestamp]
    def executionStatus: zio.aws.swf.model.ExecutionStatus
    def closeStatus: Option[zio.aws.swf.model.CloseStatus]
    def parent: Option[zio.aws.swf.model.WorkflowExecution.ReadOnly]
    def tagList: Option[List[Tag]]
    def cancelRequested: Option[Canceled]
    def getExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(execution)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getStartTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startTimestamp)
    def getCloseTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("closeTimestamp", closeTimestamp)
    def getExecutionStatus
        : ZIO[Any, Nothing, zio.aws.swf.model.ExecutionStatus] =
      ZIO.succeed(executionStatus)
    def getCloseStatus: ZIO[Any, AwsError, zio.aws.swf.model.CloseStatus] =
      AwsError.unwrapOptionField("closeStatus", closeStatus)
    def getParent
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      AwsError.unwrapOptionField("parent", parent)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getCancelRequested: ZIO[Any, AwsError, Canceled] =
      AwsError.unwrapOptionField("cancelRequested", cancelRequested)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo
  ) extends zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly {
    override val execution: zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.execution())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val startTimestamp: Timestamp =
      zio.aws.swf.model.primitives.Timestamp(impl.startTimestamp())
    override val closeTimestamp: Option[Timestamp] = scala
      .Option(impl.closeTimestamp())
      .map(value => zio.aws.swf.model.primitives.Timestamp(value))
    override val executionStatus: zio.aws.swf.model.ExecutionStatus =
      zio.aws.swf.model.ExecutionStatus.wrap(impl.executionStatus())
    override val closeStatus: Option[zio.aws.swf.model.CloseStatus] = scala
      .Option(impl.closeStatus())
      .map(value => zio.aws.swf.model.CloseStatus.wrap(value))
    override val parent: Option[zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      scala
        .Option(impl.parent())
        .map(value => zio.aws.swf.model.WorkflowExecution.wrap(value))
    override val tagList: Option[List[Tag]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val cancelRequested: Option[Canceled] = scala
      .Option(impl.cancelRequested())
      .map(value => zio.aws.swf.model.primitives.Canceled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo
  ): zio.aws.swf.model.WorkflowExecutionInfo.ReadOnly = new Wrapper(impl)
}
