package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.Tag
import scala.jdk.CollectionConverters.*
final case class TagFilter(tag: Tag) {
  def buildAwsValue(): software.amazon.awssdk.services.swf.model.TagFilter = {
    import TagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TagFilter
      .builder()
      .tag(Tag.unwrap(tag): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TagFilter.ReadOnly =
    zio.aws.swf.model.TagFilter.wrap(buildAwsValue())
}
object TagFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.TagFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TagFilter =
      zio.aws.swf.model.TagFilter(tag)
    def tag: Tag
    def getTag: ZIO[Any, Nothing, Tag] = ZIO.succeed(tag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TagFilter
  ) extends zio.aws.swf.model.TagFilter.ReadOnly {
    override val tag: Tag = zio.aws.swf.model.primitives.Tag(impl.tag())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TagFilter
  ): zio.aws.swf.model.TagFilter.ReadOnly = new Wrapper(impl)
}
