package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, FunctionName, FunctionId}
import scala.jdk.CollectionConverters.*
final case class ScheduleLambdaFunctionFailedEventAttributes(
    id: FunctionId,
    name: FunctionName,
    cause: zio.aws.swf.model.ScheduleLambdaFunctionFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes = {
    import ScheduleLambdaFunctionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes
      .builder()
      .id(FunctionId.unwrap(id): java.lang.String)
      .name(FunctionName.unwrap(name): java.lang.String)
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes
      .wrap(buildAwsValue())
}
object ScheduleLambdaFunctionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes =
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes(
        id,
        name,
        cause,
        decisionTaskCompletedEventId
      )
    def id: FunctionId
    def name: FunctionName
    def cause: zio.aws.swf.model.ScheduleLambdaFunctionFailedCause
    def decisionTaskCompletedEventId: EventId
    def getId: ZIO[Any, Nothing, FunctionId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.ScheduleLambdaFunctionFailedCause
    ] = ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes
  ) extends zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly {
    override val id: FunctionId =
      zio.aws.swf.model.primitives.FunctionId(impl.id())
    override val name: FunctionName =
      zio.aws.swf.model.primitives.FunctionName(impl.name())
    override val cause: zio.aws.swf.model.ScheduleLambdaFunctionFailedCause =
      zio.aws.swf.model.ScheduleLambdaFunctionFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes
  ): zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
