package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  FunctionId,
  Data,
  EventId,
  FunctionInput,
  FunctionName,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionScheduledEventAttributes(
    id: FunctionId,
    name: FunctionName,
    control: Option[Data] = None,
    input: Option[FunctionInput] = None,
    startToCloseTimeout: Option[DurationInSecondsOptional] = None,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.LambdaFunctionScheduledEventAttributes = {
    import LambdaFunctionScheduledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.LambdaFunctionScheduledEventAttributes
      .builder()
      .id(FunctionId.unwrap(id): java.lang.String)
      .name(FunctionName.unwrap(name): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(
        input.map(value => FunctionInput.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly =
    zio.aws.swf.model.LambdaFunctionScheduledEventAttributes
      .wrap(buildAwsValue())
}
object LambdaFunctionScheduledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.LambdaFunctionScheduledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.LambdaFunctionScheduledEventAttributes =
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes(
        id,
        name,
        control.map(value => value),
        input.map(value => value),
        startToCloseTimeout.map(value => value),
        decisionTaskCompletedEventId
      )
    def id: FunctionId
    def name: FunctionName
    def control: Option[Data]
    def input: Option[FunctionInput]
    def startToCloseTimeout: Option[DurationInSecondsOptional]
    def decisionTaskCompletedEventId: EventId
    def getId: ZIO[Any, Nothing, FunctionId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, FunctionInput] =
      AwsError.unwrapOptionField("input", input)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionScheduledEventAttributes
  ) extends zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly {
    override val id: FunctionId =
      zio.aws.swf.model.primitives.FunctionId(impl.id())
    override val name: FunctionName =
      zio.aws.swf.model.primitives.FunctionName(impl.name())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Option[FunctionInput] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.FunctionInput(value))
    override val startToCloseTimeout: Option[DurationInSecondsOptional] = scala
      .Option(impl.startToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionScheduledEventAttributes
  ): zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
