package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.PageToken
import scala.jdk.CollectionConverters.*
final case class ListDomainsResponse(
    domainInfos: Iterable[zio.aws.swf.model.DomainInfo],
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListDomainsResponse = {
    import ListDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListDomainsResponse
      .builder()
      .domainInfos(domainInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListDomainsResponse.ReadOnly =
    zio.aws.swf.model.ListDomainsResponse.wrap(buildAwsValue())
}
object ListDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListDomainsResponse =
      zio.aws.swf.model.ListDomainsResponse(
        domainInfos.map { item =>
          item.asEditable
        },
        nextPageToken.map(value => value)
      )
    def domainInfos: List[zio.aws.swf.model.DomainInfo.ReadOnly]
    def nextPageToken: Option[PageToken]
    def getDomainInfos
        : ZIO[Any, Nothing, List[zio.aws.swf.model.DomainInfo.ReadOnly]] =
      ZIO.succeed(domainInfos)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListDomainsResponse
  ) extends zio.aws.swf.model.ListDomainsResponse.ReadOnly {
    override val domainInfos: List[zio.aws.swf.model.DomainInfo.ReadOnly] = impl
      .domainInfos()
      .asScala
      .map { item =>
        zio.aws.swf.model.DomainInfo.wrap(item)
      }
      .toList
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListDomainsResponse
  ): zio.aws.swf.model.ListDomainsResponse.ReadOnly = new Wrapper(impl)
}
