package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters.*
final case class DecisionTaskTimedOutEventAttributes(
    timeoutType: zio.aws.swf.model.DecisionTaskTimeoutType,
    scheduledEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DecisionTaskTimedOutEventAttributes = {
    import DecisionTaskTimedOutEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DecisionTaskTimedOutEventAttributes
      .builder()
      .timeoutType(timeoutType.unwrap)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly =
    zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.wrap(buildAwsValue())
}
object DecisionTaskTimedOutEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DecisionTaskTimedOutEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DecisionTaskTimedOutEventAttributes =
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes(
        timeoutType,
        scheduledEventId,
        startedEventId
      )
    def timeoutType: zio.aws.swf.model.DecisionTaskTimeoutType
    def scheduledEventId: EventId
    def startedEventId: EventId
    def getTimeoutType
        : ZIO[Any, Nothing, zio.aws.swf.model.DecisionTaskTimeoutType] =
      ZIO.succeed(timeoutType)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskTimedOutEventAttributes
  ) extends zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly {
    override val timeoutType: zio.aws.swf.model.DecisionTaskTimeoutType =
      zio.aws.swf.model.DecisionTaskTimeoutType.wrap(impl.timeoutType())
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskTimedOutEventAttributes
  ): zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly =
    new Wrapper(impl)
}
