package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait CancelWorkflowExecutionFailedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause
}
object CancelWorkflowExecutionFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause
  ): zio.aws.swf.model.CancelWorkflowExecutionFailedCause = value match {
    case software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause.UNHANDLED_DECISION =>
      val r = UNHANDLED_DECISION
      r
    case software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause.OPERATION_NOT_PERMITTED =>
      val r = OPERATION_NOT_PERMITTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.CancelWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object UNHANDLED_DECISION
      extends zio.aws.swf.model.CancelWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause.UNHANDLED_DECISION
  }
  case object OPERATION_NOT_PERMITTED
      extends zio.aws.swf.model.CancelWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionFailedCause.OPERATION_NOT_PERMITTED
  }
}
