package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class ExternalWorkflowExecutionCancelRequestedEventAttributes(
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    initiatedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes = {
    import ExternalWorkflowExecutionCancelRequestedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
      .builder()
      .workflowExecution(workflowExecution.buildAwsValue())
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly =
    zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
      .wrap(buildAwsValue())
}
object ExternalWorkflowExecutionCancelRequestedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes =
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes(
        workflowExecution.asEditable,
        initiatedEventId
      )
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def initiatedEventId: EventId
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
  ) extends zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly {
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
  ): zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
