package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  Tag,
  Arn,
  DurationInSecondsOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class StartChildWorkflowExecutionDecisionAttributes(
    workflowType: zio.aws.swf.model.WorkflowType,
    workflowId: WorkflowId,
    control: Optional[Data] = Optional.Absent,
    input: Optional[Data] = Optional.Absent,
    executionStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    taskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    childPolicy: Optional[zio.aws.swf.model.ChildPolicy] = Optional.Absent,
    tagList: Optional[Iterable[Tag]] = Optional.Absent,
    lambdaRole: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes = {
    import StartChildWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes
      .builder()
      .workflowType(workflowType.buildAwsValue())
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .optionallyWith(childPolicy.map(value => value.unwrap))(_.childPolicy)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object StartChildWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes(
        workflowType.asEditable,
        workflowId,
        control.map(value => value),
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        taskList.map(value => value.asEditable),
        taskPriority.map(value => value),
        taskStartToCloseTimeout.map(value => value),
        childPolicy.map(value => value),
        tagList.map(value => value),
        lambdaRole.map(value => value)
      )
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def workflowId: WorkflowId
    def control: Optional[Data]
    def input: Optional[Data]
    def executionStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def taskPriority: Optional[TaskPriority]
    def taskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def childPolicy: Optional[zio.aws.swf.model.ChildPolicy]
    def tagList: Optional[List[Tag]]
    def lambdaRole: Optional[Arn]
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getChildPolicy: ZIO[Any, AwsError, zio.aws.swf.model.ChildPolicy] =
      AwsError.unwrapOptionField("childPolicy", childPolicy)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly {
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val control: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskList())
        .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val childPolicy: Optional[zio.aws.swf.model.ChildPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childPolicy())
        .map(value => zio.aws.swf.model.ChildPolicy.wrap(value))
    override val tagList: Optional[List[Tag]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val lambdaRole: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
