package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{Version, Name}
import scala.jdk.CollectionConverters._
final case class WorkflowType(name: Name, version: Version) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowType = {
    import WorkflowType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowType
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowType.ReadOnly =
    zio.aws.swf.model.WorkflowType.wrap(buildAwsValue())
}
object WorkflowType {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.WorkflowType] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowType =
      zio.aws.swf.model.WorkflowType(name, version)
    def name: Name
    def version: Version
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowType
  ) extends zio.aws.swf.model.WorkflowType.ReadOnly {
    override val name: Name = zio.aws.swf.model.primitives.Name(impl.name())
    override val version: Version =
      zio.aws.swf.model.primitives.Version(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowType
  ): zio.aws.swf.model.WorkflowType.ReadOnly = new Wrapper(impl)
}
