package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.WorkflowId
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionFilter(workflowId: WorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter = {
    import WorkflowExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionFilter.wrap(buildAwsValue())
}
object WorkflowExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionFilter =
      zio.aws.swf.model.WorkflowExecutionFilter(workflowId)
    def workflowId: WorkflowId
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter
  ) extends zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter
  ): zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly = new Wrapper(impl)
}
