package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{VersionOptional, Name}
import scala.jdk.CollectionConverters._
final case class WorkflowTypeFilter(
    name: Name,
    version: Optional[VersionOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowTypeFilter = {
    import WorkflowTypeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowTypeFilter
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        version.map(value => VersionOptional.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowTypeFilter.ReadOnly =
    zio.aws.swf.model.WorkflowTypeFilter.wrap(buildAwsValue())
}
object WorkflowTypeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowTypeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowTypeFilter =
      zio.aws.swf.model.WorkflowTypeFilter(name, version.map(value => value))
    def name: Name
    def version: Optional[VersionOptional]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, VersionOptional] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowTypeFilter
  ) extends zio.aws.swf.model.WorkflowTypeFilter.ReadOnly {
    override val name: Name = zio.aws.swf.model.primitives.Name(impl.name())
    override val version: Optional[VersionOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.swf.model.primitives.VersionOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowTypeFilter
  ): zio.aws.swf.model.WorkflowTypeFilter.ReadOnly = new Wrapper(impl)
}
