package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait StartLambdaFunctionFailedCause {
  def unwrap
      : software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause
}
object StartLambdaFunctionFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause
  ): zio.aws.swf.model.StartLambdaFunctionFailedCause = value match {
    case software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause.ASSUME_ROLE_FAILED =>
      val r = ASSUME_ROLE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.StartLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSUME_ROLE_FAILED
      extends zio.aws.swf.model.StartLambdaFunctionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause =
      software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedCause.ASSUME_ROLE_FAILED
  }
}
