package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, TimerId}
import scala.jdk.CollectionConverters._
final case class CancelTimerFailedEventAttributes(
    timerId: TimerId,
    cause: zio.aws.swf.model.CancelTimerFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CancelTimerFailedEventAttributes = {
    import CancelTimerFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CancelTimerFailedEventAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.CancelTimerFailedEventAttributes.wrap(buildAwsValue())
}
object CancelTimerFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CancelTimerFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CancelTimerFailedEventAttributes =
      zio.aws.swf.model.CancelTimerFailedEventAttributes(
        timerId,
        cause,
        decisionTaskCompletedEventId
      )
    def timerId: TimerId
    def cause: zio.aws.swf.model.CancelTimerFailedCause
    def decisionTaskCompletedEventId: EventId
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
    def getCause: ZIO[Any, Nothing, zio.aws.swf.model.CancelTimerFailedCause] =
      ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CancelTimerFailedEventAttributes
  ) extends zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
    override val cause: zio.aws.swf.model.CancelTimerFailedCause =
      zio.aws.swf.model.CancelTimerFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CancelTimerFailedEventAttributes
  ): zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly = new Wrapper(
    impl
  )
}
