package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class ChildWorkflowExecutionTimedOutEventAttributes(
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    workflowType: zio.aws.swf.model.WorkflowType,
    timeoutType: zio.aws.swf.model.WorkflowExecutionTimeoutType,
    initiatedEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes = {
    import ChildWorkflowExecutionTimedOutEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
      .builder()
      .workflowExecution(workflowExecution.buildAwsValue())
      .workflowType(workflowType.buildAwsValue())
      .timeoutType(timeoutType.unwrap)
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly =
    zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
      .wrap(buildAwsValue())
}
object ChildWorkflowExecutionTimedOutEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes =
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes(
        workflowExecution.asEditable,
        workflowType.asEditable,
        timeoutType,
        initiatedEventId,
        startedEventId
      )
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def timeoutType: zio.aws.swf.model.WorkflowExecutionTimeoutType
    def initiatedEventId: EventId
    def startedEventId: EventId
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getTimeoutType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecutionTimeoutType] =
      ZIO.succeed(timeoutType)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
  ) extends zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly {
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val timeoutType: zio.aws.swf.model.WorkflowExecutionTimeoutType =
      zio.aws.swf.model.WorkflowExecutionTimeoutType.wrap(impl.timeoutType())
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
  ): zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly =
    new Wrapper(impl)
}
