package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait SignalExternalWorkflowExecutionFailedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause
}
object SignalExternalWorkflowExecutionFailedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause
  ): zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause =
    value match {
      case software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION =>
        val r = UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION
        r
      case software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED =>
        val r = SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED
        r
      case software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.OPERATION_NOT_PERMITTED =>
        val r = OPERATION_NOT_PERMITTED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION
      extends zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION
  }
  case object SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED
      extends zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED
  }
  case object OPERATION_NOT_PERMITTED
      extends zio.aws.swf.model.SignalExternalWorkflowExecutionFailedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause =
      software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause.OPERATION_NOT_PERMITTED
  }
}
