package zio.aws.swf.model
import zio.aws.swf.model.primitives.{
  ReverseOrder,
  PageSize,
  PageToken,
  DomainName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListClosedWorkflowExecutionsRequest(
    domain: DomainName,
    startTimeFilter: Optional[zio.aws.swf.model.ExecutionTimeFilter] =
      Optional.Absent,
    closeTimeFilter: Optional[zio.aws.swf.model.ExecutionTimeFilter] =
      Optional.Absent,
    executionFilter: Optional[zio.aws.swf.model.WorkflowExecutionFilter] =
      Optional.Absent,
    closeStatusFilter: Optional[zio.aws.swf.model.CloseStatusFilter] =
      Optional.Absent,
    typeFilter: Optional[zio.aws.swf.model.WorkflowTypeFilter] =
      Optional.Absent,
    tagFilter: Optional[zio.aws.swf.model.TagFilter] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent,
    maximumPageSize: Optional[PageSize] = Optional.Absent,
    reverseOrder: Optional[ReverseOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest = {
    import ListClosedWorkflowExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(startTimeFilter.map(value => value.buildAwsValue()))(
        _.startTimeFilter
      )
      .optionallyWith(closeTimeFilter.map(value => value.buildAwsValue()))(
        _.closeTimeFilter
      )
      .optionallyWith(executionFilter.map(value => value.buildAwsValue()))(
        _.executionFilter
      )
      .optionallyWith(closeStatusFilter.map(value => value.buildAwsValue()))(
        _.closeStatusFilter
      )
      .optionallyWith(typeFilter.map(value => value.buildAwsValue()))(
        _.typeFilter
      )
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ListClosedWorkflowExecutionsRequest.ReadOnly =
    zio.aws.swf.model.ListClosedWorkflowExecutionsRequest.wrap(buildAwsValue())
}
object ListClosedWorkflowExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListClosedWorkflowExecutionsRequest =
      zio.aws.swf.model.ListClosedWorkflowExecutionsRequest(
        domain,
        startTimeFilter.map(value => value.asEditable),
        closeTimeFilter.map(value => value.asEditable),
        executionFilter.map(value => value.asEditable),
        closeStatusFilter.map(value => value.asEditable),
        typeFilter.map(value => value.asEditable),
        tagFilter.map(value => value.asEditable),
        nextPageToken.map(value => value),
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def domain: DomainName
    def startTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly]
    def closeTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly]
    def executionFilter
        : Optional[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly]
    def closeStatusFilter
        : Optional[zio.aws.swf.model.CloseStatusFilter.ReadOnly]
    def typeFilter: Optional[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly]
    def tagFilter: Optional[zio.aws.swf.model.TagFilter.ReadOnly]
    def nextPageToken: Optional[PageToken]
    def maximumPageSize: Optional[PageSize]
    def reverseOrder: Optional[ReverseOrder]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getStartTimeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      AwsError.unwrapOptionField("startTimeFilter", startTimeFilter)
    def getCloseTimeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      AwsError.unwrapOptionField("closeTimeFilter", closeTimeFilter)
    def getExecutionFilter: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("executionFilter", executionFilter)
    def getCloseStatusFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.CloseStatusFilter.ReadOnly] =
      AwsError.unwrapOptionField("closeStatusFilter", closeStatusFilter)
    def getTypeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      AwsError.unwrapOptionField("typeFilter", typeFilter)
    def getTagFilter: ZIO[Any, AwsError, zio.aws.swf.model.TagFilter.ReadOnly] =
      AwsError.unwrapOptionField("tagFilter", tagFilter)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest
  ) extends zio.aws.swf.model.ListClosedWorkflowExecutionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val startTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeFilter())
        .map(value => zio.aws.swf.model.ExecutionTimeFilter.wrap(value))
    override val closeTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.closeTimeFilter())
        .map(value => zio.aws.swf.model.ExecutionTimeFilter.wrap(value))
    override val executionFilter
        : Optional[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionFilter())
        .map(value => zio.aws.swf.model.WorkflowExecutionFilter.wrap(value))
    override val closeStatusFilter
        : Optional[zio.aws.swf.model.CloseStatusFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.closeStatusFilter())
        .map(value => zio.aws.swf.model.CloseStatusFilter.wrap(value))
    override val typeFilter
        : Optional[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeFilter())
        .map(value => zio.aws.swf.model.WorkflowTypeFilter.wrap(value))
    override val tagFilter: Optional[zio.aws.swf.model.TagFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilter())
        .map(value => zio.aws.swf.model.TagFilter.wrap(value))
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val maximumPageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Optional[ReverseOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest
  ): zio.aws.swf.model.ListClosedWorkflowExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
